using System;
using System.Collections.Generic;

public class CaveRoom
{
    public int RoomNumber { get; set; }
    public List<int> ConnectedRooms { get; set; }

    public CaveRoom(int roomNumber)
    {
        RoomNumber = roomNumber;
        ConnectedRooms = new List<int>();
    }
}

public class CaveSystem
{
    public Dictionary<int, CaveRoom> Rooms { get; set; }

    public CaveSystem(int n)
    {
        Rooms = new Dictionary<int, CaveRoom>();
        for (int i = 1; i <= n; i++)
        {
            Rooms[i] = new CaveRoom(i);
        }
    }

    public void AddConnection(int roomA, int roomB)
    {
        Rooms[roomA].ConnectedRooms.Add(roomB);
        Rooms[roomB].ConnectedRooms.Add(roomA);
    }
}